\name{WU_Research}
\alias{WU_Research}
\encoding{UTF-8}
\docType{data}
\title{WU Research Dublin Core Metadata}
\description{
  Dublin Core metadata for research at WU (Wirtschaftsuniversität Wien).
}
\usage{
data("WU_Research")
}
\format{
  A list matrix of character vectors, with rows corresponding to theses
  and the 15 columns giving the respective Dublin Core elements
  (variables).

  Variables \code{author}, \code{title}, and \code{description} give the
  author, title and abstract of the thesis, respectively.  Finally,
  \code{subject} gives keywords.
}
\details{
  Metadata were obtained from the WU Research OAI repository at
  \url{https://research.wu.ac.at/ws/oai} via package \pkg{OAIHarvester} 
  (\url{https://CRAN.R-project.org/package=OAIHarvester}).
  
  See the documentation of package \pkg{OAIHarvester} for more
  information on Dublin Core and OAI, and
  \url{https://research.wu.ac.at/} for information about research at
  WU.
}
\examples{
data("WU_Research")
## Inspect the first records:
head(WU_Research)
## Records with creator names matching 'Hornik':
ind <- vapply(WU_Research[, "creator"],
              function(e) any(grepl("Hornik", e)),
              NA)
WU_Research_KH <- WU_Research[ind, ]
## Most recent ones:
pos <- order(substring(unlist(WU_Research_KH[, "date"]), 1L, 4L))
write.dcf(tail(WU_Research_KH[pos, ]))
}
\keyword{datasets}
